class EasyToDoList < ActiveRecord::Base
  include Redmine::SafeAttributes

  default_scope{order("#{EasyToDoList.table_name}.position ASC")}

  belongs_to :user
  has_many :easy_to_do_list_items, :dependent => :destroy

  acts_as_positioned :scope => :user_id

  validates :name, :presence => true, :length => { :maximum => 255 }

  attr_protected :id

  attr_accessor :new_position

  safe_attributes 'name', 'new_position'

  before_save :ensure_new_position

  private

  def ensure_new_position
    return if self.new_position.blank?
    new_new_position = self.new_position
    self.new_position = nil
    self.position = new_new_position.to_i
  end

end
