class EasyToDoListItemsController < ApplicationController

  before_action :find_easy_to_do_list, :only => [:create, :update, :destroy]
  before_action :find_easy_to_do_list_item, :only => [:update, :destroy]

  def show
    render :nothing => true
  end

  def new
    render :nothing => true
  end

  def create
    @easy_to_do_list_item = @easy_to_do_list.easy_to_do_list_items.build
    @easy_to_do_list_item.safe_attributes = params[:easy_to_do_list_item] if params[:easy_to_do_list_item]
    @easy_to_do_list_item.new_position ||= 1

    if @easy_to_do_list_item.save
      respond_to do |format|
        format.js {render :partial => 'easy_to_do_list_items/show', :formats => [:html], :locals => {:easy_to_do_list => @easy_to_do_list, :easy_to_do_list_item => @easy_to_do_list_item}}
      end
    else
      respond_to do |format|
        format.js {render :nothing => true}
      end
    end
  end

  def edit
    render :nothing => true
  end

  def update
    @easy_to_do_list_item.safe_attributes = params[:easy_to_do_list_item] if params[:easy_to_do_list_item]
    @easy_to_do_list_item.old_list = (@easy_to_do_list_item.new_list.blank? || @easy_to_do_list_item.new_list.to_i == @easy_to_do_list_item.easy_to_do_list.id) ? nil : @easy_to_do_list_item.easy_to_do_list
    new_list = @easy_to_do_list_item.new_list ? EasyToDoList.find(@easy_to_do_list_item.new_list) : @easy_to_do_list_item.easy_to_do_list
    if @easy_to_do_list_item.save
      respond_to do |format|
        format.js {render :partial => 'easy_to_do_list_items/show', :formats => [:html], :locals => {:easy_to_do_list => new_list, :easy_to_do_list_item => @easy_to_do_list_item}}
      end
    else
      respond_to do |format|
        format.js {render :nothing => true}
      end
    end
  end

  def destroy
    @easy_to_do_list_item.destroy

    respond_to do |format|
      format.js {render :nothing => true}
    end
  end

  private

  def find_easy_to_do_list
    @easy_to_do_list = User.current.easy_to_do_lists.find(params[:easy_to_do_list_id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def find_easy_to_do_list_item
    @easy_to_do_list_item = @easy_to_do_list.easy_to_do_list_items.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

end
