Dir[File.dirname(__FILE__) + '/lib/easy_to_do_list/redmine/controllers/*.rb'].each {|file| require_dependency file }
Dir[File.dirname(__FILE__) + '/lib/easy_to_do_list/redmine/helpers/*.rb'].each {|file| require_dependency file }
Dir[File.dirname(__FILE__) + '/lib/easy_to_do_list/redmine/models/*.rb'].each {|file| require_dependency file }
Dir[File.dirname(__FILE__) + '/lib/easy_to_do_list/redmine/others/*.rb'].each {|file| require_dependency file }

ActiveSupport.on_load(:easyproject, yield: true) do
  require 'easy_to_do_list/hooks'

  Redmine::MenuManager.map :easy_servicebar_items do |menu|
    menu.push(:easy_to_do_list_toolbar, {:controller => 'easy_to_do_lists', :action => 'show_toolbar'}, :html => {
      :class => 'icon-issue-status',
      :id => 'easy_to_do_list_toolbar_trigger',
      :title => EasyExtensions::MenuManagerProc.new {I18n.t(:heading_easy_to_do_list)},
      :remote => true
      },
      :caption => '',
      :param => :project_id,
      :if => lambda{|project| User.current.logged? && User.current.allowed_to_globally?(:use_easy_to_do_list, {}) }
      )
  end

  Redmine::AccessControl.map do |map|
    map.easy_category(:easy_to_do_list) do |pmap|
      pmap.permission(:use_easy_to_do_list, {}, :global => true)
    end
  end

end
