module EasyProjectCom
  module Menus

    ESHOP_URL = { controller: :easy_pages, action: :custom_easy_page, identifier: 'client-zone' }

    Redmine::MenuManager.map :top_menu do |menu|
      menu.delete :my_account
      menu.delete :easy_calendar
      menu.delete :templates
      menu.delete :others
      menu.delete :documents
      menu.delete :easy_versions
      menu.delete :easy_gantt
      menu.delete :easy_gantt_resources
      menu.easy_delete :users_new

      menu.push :easy_project_easy_is_easy_template, :templates_path, {
          caption: :label_templates_plural,
          html: { class: 'icon icon-project' },
          if: proc { Project.allowed_to_create_project_from_template? }
      }
      menu.push(:documents, :documents_path, {
          caption: :label_document_global,
          if: proc { User.current.allowed_to_globally?(:view_documents) },
          html: { class: 'icon icon-copy' }
      })
      menu.push(:easy_versions, :easy_versions_path, {
          caption: :label_easy_versions_top_menu,
          if: proc { User.current.allowed_to_globally?(:manage_global_versions) },
          html: { class: 'icon icon-list' }
      })
      menu.push(:easy_gantt, { controller: 'easy_gantt', action: 'index', set_filter: 0 },
                caption: :button_top_menu_easy_gantt,
                after: :documents,
                html: { class: 'icon icon-stats' },
                if: proc { User.current.allowed_to_globally?(:view_global_easy_gantt) }
      )
      menu.push(:time_entries, { controller: 'timelog', action: 'index', set_filter: 0 }, {
                caption: :label_time_reports,
                html: { class: 'icon icon-calendar' },
                if: proc { User.current.logged? }
      })
    end

    Redmine::MenuManager.map :admin_projects_easy_page_layout_service_box do |menu|
      menu.delete :new_project
      menu.delete :new_project_from_template
    end

    Redmine::MenuManager.map :easy_quick_top_menu do |menu|
      menu.delete :my_page
      menu.delete :projects
      menu.delete :issues

      menu.push :my_page, { controller: 'my', action: 'page' },
                if: proc { !User.current.in_mobile_view? && User.current.easy_user_type_for?(:home_icon) },
                caption: :label_my_dashboard,
                html: {
                    title: EasyExtensions::MenuManagerProc.new { I18n.t(:label_home) },
                    class: 'icon icon-dashboard'
                }

      menu.push :projects, { controller: 'projects', action: 'index', set_filter: 0 },
                caption: :label_project_plural,
                html: {
                    title: EasyExtensions::MenuManagerProc.new { I18n.t(:label_project_plural) },
                    class: 'icon icon-project'
                },
                if: proc { (Setting.login_required? ? User.current.logged? : true) && User.current.easy_user_type_for?(:projects) }

      menu.push :issues, { controller: 'issues', action: 'index', set_filter: 0, project_id: nil },
                caption: :label_issue_plural,
                html: {
                    title: EasyExtensions::MenuManagerProc.new { I18n.t(:label_issue_plural) },
                    class: 'icon icon-issue'
                },
                if: proc { (Setting.login_required? ? User.current.logged? : true) && User.current.allowed_to?(:view_issues, nil, global: true) && User.current.easy_user_type_for?(:issues) }
    end

    Redmine::MenuManager.map :easy_new_entity do |menu|

      menu.push :issues_new, { controller: 'issues', action: 'new' }, {
          param: :project_id,
          caption: :label_issue,
          html: { class: 'icon-issue button-positive', render_partial_path: 'common/easy_action_buttons' },
          if: Proc.new { User.current.allowed_to_globally?(:add_issues) }
      }

      menu.push :project_limit_exceeded, :easy_trial_expiration_limit_reached_path, {
          caption: :label_project,
          html: { class: 'icon-project button-positive', render_partial_path: 'common/easy_action_buttons', remote: true },
          if: Proc.new { !EasyLicenseManager.has_license_limit?(:active_project_limit) && (User.current.allowed_to_globally?(:add_project) || User.current.allowed_to_globally?(:add_subprojects)) }
      }

      menu.push :projects_new, :new_project_path, {
          caption: :label_project,
          html: { class: 'icon-project button-positive', render_partial_path: 'common/easy_action_buttons' },
          if: Proc.new { EasyLicenseManager.has_license_limit?(:active_project_limit) && (User.current.allowed_to_globally?(:add_project) || User.current.allowed_to_globally?(:add_subprojects)) }
      }

      menu.push :log_time_new, :easy_new_entity_time_entry_path, {
          param: :project_id,
          caption: :button_log_time,
          html: { class: 'icon-time-add button-positive', render_partial_path: 'common/easy_action_buttons', remote: true },
          if: Proc.new { |project| User.current.allowed_to?(:log_time, project, global: true) }
      }

      menu.push :easy_knowledge_new, :new_easy_knowledge_story_path, {
          caption: :label_easy_knowledge_story_post,
          html: { class: 'icon-bulb button-positive', render_partial_path: 'common/easy_action_buttons' },
          if: Proc.new { User.current.allowed_to_globally?(:manage_user_stories) || User.current.allowed_to_globally?(:create_global_stories) }
      } if Redmine::Plugin.installed?(:easy_knowledge)

      menu.push :easy_invoicing_new, { controller: 'easy_invoices', action: 'new' }, {
          caption: :label_easy_invoice,
          html: { class: 'icon-invoice button-positive', render_partial_path: 'common/easy_action_buttons', remote: true },
          if: Proc.new { EasyInvoice.editable_globally? }
      } if Redmine::Plugin.installed?(:easy_invoicing)

      menu.push :easy_crm_new, { controller: 'easy_crm_cases', action: 'new' }, {
          caption: :field_easy_crm_case,
          html: { class: 'icon-crm-1 button-positive', render_partial_path: 'common/easy_action_buttons' },
          if: Proc.new { User.current.allowed_to_globally?(:edit_own_easy_crm_cases) || User.current.allowed_to_globally?(:edit_easy_crm_cases) }
      } if Redmine::Plugin.installed?(:easy_crm)

      menu.push :easy_contacts_new, :new_easy_contact_path, {
          caption: :label_easy_contact,
          html: { class: 'icon-user button-positive', render_partial_path: 'common/easy_action_buttons' },
          if: Proc.new { User.current.allowed_to_globally?(:manage_easy_contacts) }
      } if Redmine::Plugin.installed?(:easy_contacts)

      menu.push :easy_zoom_meeting_new, :easy_zoom_meeting_new_entity_path, {
          caption: :label_meeting_type_video,
          html: { class: 'icon-calendar button-positive', render_partial_path: 'common/easy_action_buttons', data: {remote: true} },
          if: Proc.new { EasyZoom.configured? && User.current.allowed_to_globally?(:view_easy_calendar) }
      } if Redmine::Plugin.installed?(:easy_zoom)

    end

    Redmine::MenuManager.map :projects_easy_page_layout_service_box do |menu|
      menu.delete :new_project
      menu.delete :new_project_from_template
      menu.delete :spent_time
    end

    Redmine::MenuManager.map :project_menu do |menu|
      children = menu.menu_items.instance_variable_get(:"@children")

      children.each do |child|
        icon = " icon--#{child.name.to_s}"
        child.html_options[:class] ? child.html_options[:class] << icon : child.html_options[:class] = icon
      end

      order = [
        :overview,
        :easy_wbs,
        :gantt,
        :easy_gantt,
        :easy_kanban_board,
        :easy_scrum_board,
        :issues,
        :spent_time,
        :resource,
        :easy_earned_values,
        :easy_money,
        :documents,
        :roadmap,
        :news,
        :easy_crm,
        :easy_contacts] | children.map(&:name)

      children.sort_by! { |item| order.index(item.name) }
    end

    Redmine::MenuManager.map :top_menu_categories do |menu|
      core_modules = [ :easy_gantt, :easy_project_easy_is_easy_template, :documents, :easy_versions, :users, :time_entries ]
      extension_modules = [ :easy_gantt_resources, :easy_resource_dashboard, :easy_attendances, :easy_budgetsheet, :easy_crm, :easy_contacts, :alerts, :easy_helpdesk, :easy_money, :easy_knowledge, :test_cases ]

      menu_nodes = Redmine::MenuManager.items(:top_menu).root.children
      menu_nodes.each do |menu_node|
        menu_node.html_options[:category] = :core_features if core_modules.include?(menu_node.name)
        menu_node.html_options[:category] = :extension_modules if extension_modules.include?(menu_node.name)
        menu_node.remove_children
       menu.menu_items.add(menu_node) if menu_node.html_options[:category] || menu_node.html_options[:service]
      end
    end

    def self.build_disabled_menu_entries_easy_gantt(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-stats '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_gantt, ESHOP_URL,
                  caption: :label_easy_gantt,
                  after: :documents,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_gantt_resources(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-workflow '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_gantt_resources, ESHOP_URL,
                  caption: :button_top_menu_easy_gantt_resources,
                  after: :easy_gantt,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_resource_dashboard(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-report '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_resource_dashboard, ESHOP_URL,
                  caption: :button_top_menu_easy_resource_dashboard,
                  after: :easy_gantt_resources,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_alerts(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-warning '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:alerts, ESHOP_URL,
                  caption: :label_alerts,
                  after: :users,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_attendances(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-time '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_attendances, ESHOP_URL,
                  caption: :'easy_attendance.label',
                  before: :personal_statement,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_budgetsheet(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-bullet-list '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_budgetsheet, ESHOP_URL,
                  caption: :budgetsheet_top_menu,
                  before: :others,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_contacts(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-group '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_contacts, ESHOP_URL,
                  caption: :menu_easy_contacts,
                  first: :true,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_crm(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-crm-1 '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_crm, ESHOP_URL,
                  caption: :label_easy_crm,
                  first: :true,
                  html: html_options)
      end
    end


    # def self.build_disabled_menu_entries_easy_devops(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-settings '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:easy_devops, ESHOP_URL,
    #               caption: :label_easy_devops,
    #               first: :true,
    #               html: html_options)
    #   end
    # end

    def self.build_disabled_menu_entries_easy_helpdesk(menu_name, html_options)
      menu_options = {}
      if Redmine::Plugin.installed?(:easy_contacts)
        menu_options[:after] = :easy_contacts
      elsif Redmine::Plugin.installed?(:easy_crm)
        menu_options[:after] = :easy_crm
      else
        menu_options[:first] = true
      end
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-help-bubble '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_helpdesk, ESHOP_URL, menu_options.merge(
          caption: :easy_helpdesk_name,
          html: html_options))
      end
    end

    # def self.build_disabled_menu_entries_easy_invoicing(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-invoice '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:easy_invoicing, ESHOP_URL,
    #               caption: :label_easy_invoicing,
    #               before: Redmine::Plugin.installed?(:easy_budgetsheet) ? :easy_budgetsheet : :others,
    #               html: html_options)
    #   end
    # end

    def self.build_disabled_menu_entries_easy_knowledge(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-bulb '
      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_knowledge, ESHOP_URL,
                  caption: :menu_easy_knowledge,
                  html: html_options)
      end
    end

    def self.build_disabled_menu_entries_easy_money(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-money '

      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:easy_money, ESHOP_URL,
                  caption: :menu_easy_money,
                  before: :others,
                  html: html_options)
      end
    end

    # def self.build_disabled_menu_entries_easy_openshift_integration(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-settings '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:easy_openshift_integration, ESHOP_URL,
    #               caption: :label_easy_osi,
    #               html: html_options)
    #   end
    # end
    #
    # def self.build_disabled_menu_entries_easy_personal_finances(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-person-euro '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:easy_personal_finances, ESHOP_URL,
    #               caption: :label_easy_personal_finances_top_menu,
    #               :before => :personal_statement,
    #               html: html_options)
    #   end
    # end
    #
    # def self.build_disabled_menu_entries_easy_social_portal(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-people '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:easy_social_portal, ESHOP_URL,
    #               caption: :menu_social_portal,
    #               :after => :users,
    #               html: html_options)
    #   end
    # end
    #
    # def self.build_disabled_menu_entries_easy_user_allocations(menu_name, html_options)
    #   html_options ||= {}
    #   html_options[:class] ||= ''
    #   html_options[:class] << 'icon icon-workflow '
    #   Redmine::MenuManager.map menu_name do |menu|
    #     menu.push(:user_allocations, ESHOP_URL,
    #               caption: :label_user_allocations,
    #               :after => :users,
    #               html: html_options)
    #   end
    # end

    def self.build_disabled_menu_entries_redmine_test_cases(menu_name, html_options)
      html_options ||= {}
      html_options[:class] ||= ''
      html_options[:class] << 'icon icon-linux '
      Redmine::MenuManager.map menu_name do |menu|
        menu.push(:test_cases, ESHOP_URL,
                  caption: :label_test_cases,
                  html: html_options)
      end
    end

    Redmine::Plugin.disabled_plugins.keys.each do |plugin_name|
      build_disabled_menu_entries_method = "build_disabled_menu_entries_#{plugin_name.to_s}".to_sym
      category = :core_features if [ :easy_gantt ].include?(plugin_name)
      category = :extension_modules if [ :easy_gantt_resources, :easy_resource_dashboard, :easy_attendances, :easy_budgetsheet, :easy_crm, :easy_contacts, :easy_alerts, :easy_helpdesk, :easy_money, :easy_knowledge, :redmine_test_cases ].include?(plugin_name)
      send(build_disabled_menu_entries_method, :top_menu_categories, class: 'disabled ', category: category) if respond_to?(build_disabled_menu_entries_method ) && category
    end

    Redmine::MenuManager.map :top_menu_categories do |menu|
      children = menu.menu_items.instance_variable_get(:"@children")
      order = [
        :easy_gantt,
        :easy_project_easy_is_easy_template,
        :documents,
        :easy_versions,
        :users,
        :easy_money,
        :easy_budgetsheet,
        :easy_resource_dashboard,
        :easy_attendances,
        :easy_helpdesk,
        :alerts,
        :easy_crm,
        :easy_contacts] | children.map(&:name)

      children.sort_by! { |item| order.index(item.name) }
    end

  end
end
