module EasyProjectCom
  module EasyPatch
    module MenuHelperPatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :render_easy_custom_project_menu, :easy_project_com

          def get_custom_menu_item_links(original_items, custom_items, project)
            links = []
            return links unless custom_items

            custom_items.each do |custom_item|
              if custom_item.original_item?
                node = original_items.detect { |n| n.name.to_s == custom_item.menu_item.to_s }
                links << render_menu_node(node, project) if node
              else
                links << content_tag('li', link_to(custom_item.name, custom_item.url))
              end
            end
            links
          end

          def render_easy_project_custom_menu_for_easy_project_com(project)
            limit = 6
            original_items = Redmine::MenuManager.items(:project_menu).root.children.select { |node| node.allowed?(User.current, project) }
            custom_items = EasyCustomProjectMenu.for_project(project).sorted.to_a

            settings = original_items.detect { |i| i.name.to_s == 'settings' }
            custom_items.delete_if {|i| i.menu_item == 'settings'} if settings

            links_more = get_custom_menu_item_links(original_items, custom_items.from(limit), project)
            menu_more = links_more.empty? ? nil : content_tag('ul', links_more.join("\n").html_safe)

            menu = get_custom_menu_item_links(original_items, custom_items.first(limit), project)
            menu << content_tag('li', ( link_to('More', '#') + menu_more), class: 'main_menu__more') if menu_more
            menu << render_project_settings_menu_node(project) if settings

            menu.empty? ? nil : content_tag('ul', menu.join("\n").html_safe)
          end

          def render_project_menu_for_easy_project_com(project)
            limit = 6
            items = menu_items_for(:project_menu, project)

            settings = items.detect {|i| i.name.to_s == 'settings'}
            items.delete(settings) if settings

            links_more = []
            Array(items.from(limit)).each do |node|
              links_more << render_menu_node(node, project)
            end
            menu_more = links_more.empty? ? nil : content_tag('ul', links_more.join("\n").html_safe, class: 'menu__children')

            menu = []
            items.first(limit).each do |node|
              menu << render_menu_node(node, project)
            end
            menu << content_tag('li', ( link_to('More', '#') + menu_more), class: 'main_menu__more') if menu_more
            menu << render_project_settings_menu_node(project) if settings

            menu.empty? ? nil : content_tag('ul', menu.join.html_safe)
          end

          def render_project_settings_menu_node(project)
            if respond_to?(:project_settings_tabs)
              tabs = project_settings_tabs
            else
              p = ProjectsController.new
              p.request = request
              p.instance_variable_set(:@project, project)
              p.params = {}
              tabs = p.project_settings_tabs
            end

            links = []
            tabs.each do |tab|
              classes = "icon--#{tab[:name]}"
              if tab[:redirect_link]
                url = url_for(tab[:url])
                classes << ' selected' if request.path == url
                links << content_tag('li', (link_to(l(tab[:label]), url, class: classes)))
              else
                classes << ' selected' if params['tab'] == tab[:name]
                links << content_tag('li', (link_to(l(tab[:label]), {controller: :projects, action: :settings, tab: tab[:name], id: project.id}, class: classes)))
              end
            end

            settings_menu = links.empty? ? '' : content_tag('ul', links.join("\n").html_safe, class: 'menu__children')
            content_tag('li', ( link_to('Settings', '#') + settings_menu), class: 'main_menu__settings')
          end

        end
      end

      module InstanceMethods

        def render_easy_custom_project_menu_with_easy_project_com(project)
          if project.nil? || project.new_record?
            render_menu(:application_menu, project)
          elsif in_mobile_view?
            render_easy_custom_project_menu_without_easy_project_com(project)
          elsif !project.easy_has_custom_menu?
            render_project_menu_for_easy_project_com(project)
          else
            render_easy_project_custom_menu_for_easy_project_com(project)
          end
        end
      end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'Redmine::MenuManager::MenuHelper', 'EasyProjectCom::EasyPatch::MenuHelperPatch'
