module EasyProjectCom
  module EasyPatch
    module EasyBlockMailerPatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :mail, :easy_project_com

        end
      end

      module InstanceMethods

        def mail_with_easy_project_com(headers={}, &block)
          unless self.class.name.in? %w(EasyCalendarMailer EasyMailCampaignMailer)
            content = File.binread(File.join(EasyExtensions::EASYPROJECT_EASY_PLUGINS_DIR, 'easy_project_com/assets/images/ep-logo.png'))
            attachments['ep-logo.png'] = { content: content, content_disposition: 'inline' }
          end
          # attachments['logo_base64.png'] = {
          #     mime_type: 'image/png',
          #     content: Base64.encode64(File.read(File.join(EasyExtensions::EASYPROJECT_EASY_PLUGINS_DIR, 'easy_project_com/assets/images/logo.png')))
          # }
          mail_without_easy_project_com(headers, &block)
        end

        # module EasyCalendarMailerPatch
        #   EasyCalendarMailer.class_eval do
        #     layout 'simple_mailer'
        #   end
        # end

      end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'EasyBlockMailer', 'EasyProjectCom::EasyPatch::EasyBlockMailerPatch'
# EasyCalendarMailer.include EasyProjectCom::EasyPatch::EasyCalendarMailerPatch if Redmine::Plugin.installed?(:easy_calendar)
