#!/bin/bash -l
# -v print lines as they are read
# -x print lines as they are executed
# -e abort script at first error
set -e

export DB_USERNAME="root"
export DB_PWD=$MYSQL_PASS

function before_exit {
  return_value=$?
  bundle exec rake db:drop
  exit $return_value
}

trap before_exit SIGHUP SIGINT SIGTERM EXIT

cd ..
rm -rf redmine
git clone --depth 1 ssh://git@git.easy.cz/easyredmine/devel-2016.git redmine
cp -r brand-ep.com redmine/plugins/easyproject/easy_plugins/easy_project_com
cd redmine

# Init database
ruby -ryaml -rsecurerandom -e "
  database = 'redmine_'+SecureRandom.hex(8).to_s
  config = {
    'adapter' => 'mysql2',
    'database' => database,
    'host' => '127.0.0.1',
    'username' => ENV['DB_USERNAME'],
    'password' => ENV['DB_PWD'],
    'encoding' => 'utf8'
  }
  config = {
    'test' => config.merge({'database' => 'test_'+database}),
    'development' => config,
    'production' => config
  }.to_yaml
  File.write('config/database.yml', config)
"

bundle update
bundle exec rake db:drop db:create db:migrate
bundle exec rake easyproject:install RAILS_ENV=production
bundle exec rake test:prepare RAILS_ENV=test
bundle exec rake easyproject:tests:spec RAILS_ENV=test NAME=easy_project_com



