require File.expand_path('../../../../../easy_extensions/test/spec/spec_helper', __FILE__)

feature 'easy printable templates', js: true, logged: :admin do

  let!(:cf1) { FactoryGirl.create(:easy_contact_custom_field, :name => 'primary-show-empty', :field_format => 'string', :is_primary => true, :show_empty => true) }
  let!(:cf2) { FactoryGirl.create(:easy_contact_custom_field, :name => 'primary-hide-empty', :field_format => 'string', :is_primary => false, :show_empty => false) }
  let!(:cf3) { FactoryGirl.create(:easy_contact_custom_field, :name => 'lookup', :field_format => 'easy_lookup', :is_primary => false, :show_empty => false,
    :settings => {'entity_type' => 'User', 'entity_attribute' => 'mail'})
  }

  let(:user) { FactoryGirl.create(:user) }

  let!(:personal_easy_contact) {
    pec = FactoryGirl.build(:personal_easy_contact)
    cf1.contact_types << pec.easy_contact_type
    cf2.contact_types << pec.easy_contact_type
    cf3.contact_types << pec.easy_contact_type
    User.first.update_attributes(:mail => 'test@kkk.kk')
    pec.custom_field_values = {cf1.id => 'panda', cf2.id => 'panda2', cf3.id => user.id.to_s}
    pec.save
    pec
  }

  let(:project) {
    FactoryGirl.create(:project, :add_modules => ['easy_invoicing'])
  }

  let(:easy_invoice) {
    ei = FactoryGirl.build(:easy_invoice, :project => project)
    ei.client = personal_easy_contact
    # it validates client_ values, which are set from client
    ei.save(:validate => false)
    ei
  }

  let(:easy_printable_template) {
    t = FactoryGirl.create(:easy_printable_template, :with_easy_printable_template_pages)
    p = t.easy_printable_template_pages.first
    p.page_text = "cf: %easy_invoice_client_cf_#{cf1.id}% lookup value: %easy_invoice_client_cf_#{cf3.id}%"
    p.save
    t
  }

  if Redmine::Plugin.installed?(:easy_invoicing)
    it 'shows contact custom field in invoice correctly' do
      easy_invoice
      easy_printable_template
      easy_printable_template_page = easy_printable_template.easy_printable_template_pages.first
      visit preview_easy_printable_template_path(easy_printable_template, entity_type: easy_invoice.class.to_s, entity_id: easy_invoice.id)
      expect(page.find("#page_content_#{easy_printable_template_page.id} p")).to have_text("cf: panda lookup value: #{user.mail}")
    end

    it 'shows contact custom field in invoice correctly when client is nil' do
      easy_printable_template

      easy_invoice.update_column(:client_id, nil)

      easy_printable_template_page = easy_printable_template.easy_printable_template_pages.first

      visit preview_easy_printable_template_path(easy_printable_template, entity_type: easy_invoice.class.to_s, entity_id: easy_invoice.id)
      expect(page.find("#page_content_#{easy_printable_template_page.id} p").text).to eq 'cf:'
    end
  end

  context 'print on issues' do
    let(:easy_issue_query) { FactoryGirl.create(:easy_issue_query) }

    before(:each) do
      project
      easy_printable_template
    end

    def open_print_dialog
      page.find('#sidebar_exports a.print').click
      wait_for_ajax
      expect(page).to have_css('#easy_printable_templates')
    end

    it 'modal' do
      visit issues_path
      open_print_dialog
    end

    it 'modal with applied query' do
      visit issues_path(:query_id => easy_issue_query.id)
      open_print_dialog
    end
  end

  it 'index' do
    easy_printable_template
    visit easy_printable_templates_path(:set_filter => '1', :group_by => 'category_caption', :load_groups_opened => '1')
    wait_for_ajax
    expect(page).to have_css('.group', :count => 1)
    expect(page.find('.list td.name')).to have_content(easy_printable_template.name)
  end

end if Redmine::Plugin.installed?(:easy_contacts)
