module EasyPrintableTemplates
  module ModalSelectorsControllerPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        def easy_printable_template_to_documents
          retrieve_query(EasyDocumentQuery)
          @query.name = (params[:query_name].blank? ? l('easy_query.easy_lookup.name.document.default') : l("easy_query.easy_lookup.name.document.#{params[:query_name]}"))

          set_query(@query)

          if !params[:project_id].blank?
            project_id = params[:project_id].to_i
          elsif params[:serializable_attributes] && !params[:serializable_attributes][:project_id].blank?
            project_id = params[:serializable_attributes][:project_id].to_i
          end

          if project_id
            additional_statement = "#{Document.table_name}.project_id = #{project_id}"

            if query.additional_statement.blank?
              query.additional_statement = additional_statement
            else
              query.additional_statement << ' AND ' + additional_statement
            end
          end

          sort_init(@query.sort_criteria_init)
          sort_update(@query.sortable_columns)

          prepare_easy_query_render(@query)

          if request.xhr? && !@entities
            render_404
            return false
          end

          if loading_group?
            render_easy_query_html(@query, nil, {:selected_values => prepare_selected_values})
          else
            render_modal_selector_entities_list(@query, @entities, @entity_pages, @entity_count)
          end
        end

      end
    end

    module InstanceMethods

    end

  end

end
EasyExtensions::PatchManager.register_controller_patch 'ModalSelectorsController', 'EasyPrintableTemplates::ModalSelectorsControllerPatch'
