require File.expand_path('../../spec_helper', __FILE__)

describe :member, :logged => true do
  let!(:project) { FactoryGirl.create(:project) }
  let!(:higher_role) { FactoryGirl.create(:role, :position => 1) }
  let!(:lower_role) { FactoryGirl.create(:role, :position => 7) }
  let!(:member) { FactoryGirl.create(:member, :without_roles, project: project) }
  let!(:current_user_member) { FactoryGirl.create(:member, :without_roles, project: project, user: User.current) }

  it 'can be destroyed by current user with the same or higher role' do
    member.roles << lower_role
    current_user_member.roles << lower_role
    expect(member.deletable_by_current_user_from?(project)).to be true

    current_user_member.roles << higher_role
    expect(member.deletable_by_current_user_from?(project)).to be true
  end

  it 'can not be destroyed by current user with lower role' do
    member.roles << higher_role
    current_user_member.roles << lower_role

    expect(member.deletable_by_current_user_from?(project)).to be false
  end
end
