# encoding: utf-8
require File.expand_path('../../spec_helper', __FILE__)

feature Encoding, logged: :admin do
  it 'should preserve proper utf-8 encoding' do
    with_settings({'text_formatting' => 'HTML'}) do
      issue = FactoryGirl.create(:issue, :description => '<p>ěščřžýáíéдьявольскиеоды</p>')
      visit issue_path(issue)
      within find('#show_issue_description') do
        expect(page).to have_content('ěščřžýáíéдьявольскиеоды')
      end
    end
  end

  it 'should strip unsafe tags' do
    with_settings({'text_formatting' => 'HTML'}) do
      issue = FactoryGirl.create(:issue, :description => '<p>text</p><script type="text/javascript"></script><p>text</p>')
      visit issue_path(issue)
      within find('#show_issue_description') do
        expect(page).to(have_content('<p>') && have_content('text'))
        expect(page).not_to have_content('<script')
      end
    end
  end

  context 'autolinks' do
    def template(token)
      "<p>#{token}</p><p>text #{token} text</p><table cellpadding='1' cellspacing='1'><tbody><tr><td>#{token}</td><td>#{token} #{token}</td></tr></tbody></table>"
    end

    ['http://link.cz', 'https://link.cz', 'https://www.link.cz', 'www.link.cz'].each do |link|
      it "replace #{link}" do
        with_settings({'text_formatting' => 'HTML'}) do
          description = template(link)
          issue = FactoryGirl.create(:issue, :description => description)
          visit issue_path(issue)
          within find('#show_issue_description') do
            expect(page).to(have_css('a', :count => 5))
          end
        end
      end
    end

    ['file://127.0.0.1/~User/test.txt', 'smb://127.0.0.1/~User/test.txt'].each do |link|
      it "replace #{link}" do
        with_settings({'text_formatting' => 'HTML'}) do
          with_easy_settings({'ckeditor_autolink_file_protocols' => true}) do
            description = template(link)
            issue = FactoryGirl.create(:issue, :description => description)
            visit issue_path(issue)
            within find('#show_issue_description') do
              expect(page).to(have_css('a', :count => 5))
            end
          end
        end
      end
    end

    it 'replace email' do
      with_settings({'text_formatting' => 'HTML'}) do
        email = 'mail@test.com'
        description = template(email)
        issue = FactoryGirl.create(:issue, :description => description)
        visit issue_path(issue)
        within find('#show_issue_description') do
          expect(page).to(have_css("a[href=\"mailto:#{email}\"]", :count => 5))
        end
      end
    end
  end
end
