require File.expand_path('../../spec_helper', __FILE__)

describe WatchersController, :logged => :admin do

  let(:issue) { FactoryGirl.create(:issue) }

  render_views

  it 'new' do
    xhr :get, :new, :object_id => issue.id, :object_type => 'issue'
    expect(response).to be_success
  end

  it 'autocomplete_for_user' do
    xhr :get, :autocomplete_for_user, :object_id => issue.id, :object_type => 'issue', :easy_query_q => 'test'
    expect(response).to be_success
  end

end
