require File.expand_path('../../spec_helper', __FILE__)

describe TimelogController, :logged => :admin do

  let(:project) do
    FactoryGirl.create(:project)
  end
  let(:issue) do
    FactoryGirl.create(:issue, :project => project)
  end
  let(:time_entries) { FactoryGirl.create_list(:time_entry, 3, project: project, issue: issue) }
  let(:time_entry) { FactoryGirl.create(:time_entry, project: project, issue: issue) }

  describe 'timelog edit' do
    render_views

    it 'edit' do
      get :edit, {:id => time_entry.id}
      assert_response :success
    end

    it 'update' do
      put :update, {:id => time_entry.id, :time_entry => {:hours => '15'}}
      expect(time_entry.reload.hours).to eq(15)
    end
  end

  describe 'bulk_edit' do

    it 'get edit' do
      get :bulk_edit, {:ids => time_entries.map(&:id)}
      assert_response :success
    end

    it 'get change_projects_for_bulk_edit' do
      get :change_projects_for_bulk_edit, {:ids => time_entries.map(&:id), :format => 'json'}
      assert_response :success
    end

    it 'post change_issues_for_bulk_edit' do
      post :change_issues_for_bulk_edit, {:ids => time_entries.map(&:id)}
      assert_response :success
    end
  end

  context 'EXPORTS' do
    render_views

    it 'exports to xlsx' do
      get :index, format: 'xlsx', set_filter: '0', easy_query: {columns_to_export: 'all'}
      expect( response ).to be_success
      expect( response.content_type ).to eq( 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' )
    end

    context 'report' do
      it 'exports report to xlsx' do
        get :report, format: 'xlsx', set_filter: '1', criteria: ['project', 'activity'], columns: ['month']
        expect( response ).to be_success
        expect( response.content_type ).to eq( 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' )
      end

      it 'exports report to csv' do
        get :report, format: 'csv', set_filter: '1', criteria: ['project', 'activity'], columns: ['month']
        expect( response ).to be_success
        expect( response.content_type ).to include( 'text/csv' )
      end
    end
  end
end
