module EasyPatch
  module TimeEntryCustomFieldPatch

    def self.included(base)
      base.extend(ClassMethods)
      base.send(:include, InstanceMethods)

      base.class_eval do

        has_and_belongs_to_many :activities, -> { where(:enumerations => {:type => 'TimeEntryActivity'}) }, :join_table => "#{table_name_prefix}custom_fields_enumerations#{table_name_suffix}", :foreign_key => 'custom_field_id', :class_name => 'TimeEntryActivity', :association_foreign_key => 'enumeration_id'

        def visible_by_activity?(activity, user = User.current)
          self.visible? || self.activity_ids.include?(activity.try(:id))
        end

      end
    end

    module InstanceMethods

      def validate_custom_value(custom_value)
        if !visible? && (!custom_value.customized || activities.exclude?(custom_value.customized.activity))
          value = custom_value.value
          errs = []
          if value.is_a?(Array)
            if !multiple?
              errs << ::I18n.t('activerecord.errors.messages.invalid')
            end
          end
          errs.concat(format.validate_custom_value(custom_value))
          errs
        else
          super(custom_value)
        end
      end

      def visibility_by_project_condition(project_key = nil, user = User.current, id_column = nil)
        '(1=1)'
      end

    end

    module ClassMethods
    end
  end

end
EasyExtensions::PatchManager.register_model_patch 'TimeEntryCustomField', 'EasyPatch::TimeEntryCustomFieldPatch'
