module EasyPatch
  module MemberRolePatch

    def self.included(base)
      base.send(:include, InstanceMethods)
      base.class_eval do

        alias_method_chain :remove_inherited_roles, :easy_extensions

      end
    end

    module InstanceMethods

      def remove_inherited_roles_with_easy_extensions
        MemberRole.where(:inherited_from => id).destroy_all
      end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'MemberRole', 'EasyPatch::MemberRolePatch'
