module EasyPatch
  module IssueCustomFieldPatch

    def self.included(base)
      base.extend(ClassMethods)
      base.send(:include, InstanceMethods)

      base.class_eval do

        after_save :invalidate_external_mails_cache, :if => proc { |cf| cf.attribute_names.include?('disabled') && cf.disabled_changed? }

        def easy_groupable?
          true
        end

        def invalidate_external_mails_cache
          Rails.cache.delete('issue_cf/external_mails_id')
        end

      end
    end

    module InstanceMethods
    end

    module ClassMethods
    end
  end

end
EasyExtensions::PatchManager.register_model_patch 'IssueCustomField', 'EasyPatch::IssueCustomFieldPatch'
