module EasyPatch
  module MailHandlerControllerPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        alias_method_chain :index, :easy_extensions

      end

    end

    module InstanceMethods

      def index_with_easy_extensions
        options = params.dup
        email = options.delete(:email)
        if EasyMailHandler.receive(email, options)
          render :nothing => true, :status => :created
        else
          render :nothing => true, :status => :unprocessable_entity
        end
      end

    end

  end
end
EasyExtensions::PatchManager.register_controller_patch 'MailHandlerController', 'EasyPatch::MailHandlerControllerPatch'
