require 'mapi/msg'

module EasyPatch
  module MapiPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do
        alias_method_chain :body_html, :easy_extensions
      end
    end

    module InstanceMethods
      def body_html_with_easy_extensions
        body_html_without_easy_extensions
        @body_html = Redmine::CodesetUtil.replace_invalid_utf8(@body_html)
      end

    end

  end
end

EasyExtensions::PatchManager.register_redmine_plugin_patch 'Mapi::PropertySet', 'EasyPatch::MapiPatch'
