class EasyGroupQuery < EasyQuery

  def available_filters
    return @available_filters unless @available_filters.blank?
    @available_filters = {
        'lastname' => {:type => :text, :order => 1, :group => l("label_filter_group_#{self.class.name.underscore}")},
        'created_on' => {:type => :date_period, :order => 2, :group => l("label_filter_group_#{self.class.name.underscore}")},
        'updated_on' => {:type => :date_period, :order => 3, :group => l("label_filter_group_#{self.class.name.underscore}")}
    }
    add_custom_fields_filters(GroupCustomField)

    @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      @available_columns = [
          EasyQueryColumn.new(:lastname, :sortable => "#{Group.table_name}.lastname", :groupable => true, :group => group, :caption => :field_name),
          EasyQueryDateColumn.new(:created_on, :sortable => "#{Group.table_name}.created_on", :groupable => true, :group => group),
          EasyQueryDateColumn.new(:updated_on, :sortable => "#{Group.table_name}.updated_on", :groupable => true, :group => group)
      ]

      @available_columns.concat(GroupCustomField.all.collect { |cf| EasyQueryCustomFieldColumn.new(cf) })
      @available_columns_added = true
    end
    @available_columns
  end

  def default_list_columns
    @default_list_columns ||= ['lastname', 'created_on']
  end

  def searchable_columns
    ["#{Principal.table_name}.login", "#{Principal.table_name}.lastname", "#{Principal.table_name}.firstname", "(SELECT address FROM #{EmailAddress.table_name} WHERE user_id=#{Principal.table_name}.id AND is_default = #{self.class.connection.quoted_true} LIMIT 1)"]
  end

  def entity
    Group
  end

end
