class EasyEntityActionQuery < EasyQuery

  def initialize_available_filters
    group = l("label_filter_group_#{self.class.name.underscore}")

    add_available_filter 'name', {:type => :string, :order => 1, :group => group}
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      @available_columns = [
          EasyQueryColumn.new(:name, :sortable => "#{EasyEntityAction.table_name}.name", :group => group)
      ]

      @available_columns_added = true
    end
    @available_columns
  end

  def searchable_columns
    ["#{EasyEntityAction.table_name}.name"]
  end

  def entity
    EasyEntityAction
  end

  def default_list_columns
    super.presence || ['name']
  end

end
