class EasyAttendanceQuery < EasyQuery

  def self.permission_view_entities
    :view_easy_attendances
  end

  def entity_easy_query_path(options)
    easy_attendances_path(options)
  end

  def query_after_initialize
    super
    self.export_formats[:ics] = {:caption => 'iCal', :url => {:protocol => 'http', :key => User.current.api_key, :only_path => false}, :title => l(:title_other_formats_links_ics_outlook)}
    self.export_formats[:atom] = { url: { key: User.current.rss_key } }
    self.additional_statement = "#{EasyAttendance.table_name}.user_id = #{User.current.id}" unless User.current.allowed_to?(:view_easy_attendance_other_users, nil, :global => true)
  end

  def available_filters
    return @available_filters unless @available_filters.blank?
    default_group = l("label_filter_group_#{self.class.name.underscore}")
    @available_filters = {
        'arrival' => {:type => :date_period, :time_column => true, :order => 1, :group => default_group},
        'departure' => {:type => :date_period, :time_column => true, :order => 2, :group => default_group},
        'easy_attendance_activity_id' => {:type => :list, :order => 4, :values => Proc.new { EasyAttendanceActivity.sorted.collect { |i| [i.name, i.id.to_s] } }, :group => default_group},
        'approval_status' => {:type => :list, :order => 5, :values => l(:approval_statuses, scope: :easy_attendance).map { |key, value| [value, key] }, :group => default_group},
        'approved_by_id' => {:type => :list, :order => 5, :values => Proc.new { all_users_values }, :group => default_group},
        'approved_at' => {:type => :date_period, :time_column => true, :order => 20, :group => default_group}
    }

    if User.current.allowed_to?(:view_easy_attendance_other_users, nil, :global => true)
      @available_filters['user_id'] = {:type => :list_optional, :order => 5, :values => Proc.new do
        assigned_to_values = Array.new
        assigned_to_values << ["<< #{l(:label_me)} >>", 'me'] if User.current.logged?
        assigned_to_values.concat(User.active.non_system_flag.easy_type_internal.sorted.collect { |s| [s.name, s.id.to_s] })
      end, :group => default_group
      }
      @available_filters['group_id'] = {:type => :list, :order => 15, :values => Proc.new { Group.active.non_system_flag.sorted.collect { |i| [i.name, i.id.to_s] } }, :group => default_group}
    end

    if User.current.allowed_to?(:view_easy_attendances_extra_info, nil, :global => true)
      @available_filters['arrival_user_ip'] = {:type => :string, :order => 9, :group => default_group}
      @available_filters['departure_user_ip'] = {:type => :string, :order => 10, :group => default_group}
    end


    return @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      @available_columns = [
          EasyQueryDateColumn.new(:arrival, :sortable => "#{EasyAttendance.table_name}.arrival", :group => group),
          EasyQueryDateColumn.new(:departure, :sortable => "#{EasyAttendance.table_name}.departure", :group => group),
          EasyQueryColumn.new(:spent_time, :caption => :label_easy_attendance_spent_time, :sumable => :both, :sumable_sql => self.sql_time_diff("#{EasyAttendance.table_name}.arrival", "#{EasyAttendance.table_name}.departure"), :group => group),
          EasyQueryColumn.new(:working_time, :caption => :label_working_time, :group => group),
          EasyQueryColumn.new(:easy_attendance_activity, :groupable => true, :sortable => "#{EasyAttendanceActivity.table_name}.name", :group => group),
          EasyQueryColumn.new(:description, :group => group, :inline => false),
          EasyQueryColumn.new(:approval_status, :group => group),
          EasyQueryColumn.new(:approved_by, :groupable => "#{EasyAttendance.table_name}.approved_by_id", :sortable => lambda { User.fields_for_order_statement('approved_by_users') }, :preload => [:approved_by], :group => group),
          EasyQueryDateColumn.new(:approved_at, :group => group)
      ]
      if User.current.allowed_to?(:view_easy_attendances_extra_info, nil, :global => true)
        @available_columns << EasyQueryColumn.new(:arrival_user_ip, :sortable => "#{self.entity.table_name}.arrival_user_ip", :group => group)
        @available_columns << EasyQueryColumn.new(:departure_user_ip, :sortable => "#{self.entity.table_name}.departure_user_ip", :group => group)
      end

      @available_columns << EasyQueryDateColumn.new(:created_at, :sortable => "#{EasyAttendance.table_name}.created_at", :group => group)
      @available_columns << EasyQueryDateColumn.new(:updated_at, :sortable => "#{EasyAttendance.table_name}.updated_at", :group => group)

      group = l('label_user_plural')
      @available_columns << EasyQueryColumn.new(:user, :groupable => "#{EasyAttendance.table_name}.user_id", :sortable => lambda { User.fields_for_order_statement }, :group => group)

      @available_columns_added = true
    end
    @available_columns
  end

  def entity
    EasyAttendance
  end

  def self.chart_support?
    true
  end

  def calendar_support?
    true
  end

  def default_find_include
    [:easy_attendance_activity, :user]
  end

  def columns_with_me
    super + ['user_id']
  end

  def extended_period_options
    {
        :extended_options => [:to_today, :next_week, :tomorrow, :next_7_days, :next_30_days, :next_90_days, :next_month, :next_year]
    }
  end

  protected

  def statement_skip_fields
    ['group_id']
  end

  def add_statement_sql_before_filters
    my_fields = statement_skip_fields & filters.keys

    unless my_fields.blank?
      values = values_for('group_id').join(',')
      if values.present?
        sql = "#{EasyAttendance.table_name}.user_id IN (SELECT u.id FROM #{User.table_name} u INNER JOIN groups_users gu ON u.id = gu.user_id WHERE gu.group_id #{operator_for('group_id') == '=' ? 'IN' : 'NOT IN'} (#{values}))"

        return sql
      end
    end
  end

  def add_additional_order_statement_joins(order_options)
    joins = []
    if order_options
      if order_options.include?('approved_by')
        joins << "LEFT OUTER JOIN #{User.table_name} approved_by_users ON approved_by_users.id = #{self.entity.table_name}.approved_by_id"
      end
    end
    joins
  end

end
