class EasyPageUserTab < ActiveRecord::Base

  belongs_to :page_definition, class_name: 'EasyPage', foreign_key: 'page_id'
  belongs_to :user

  acts_as_positioned scope: [:page_id, :user_id, :entity_id]

  store :settings, coder: JSON

  attr_protected :id

  scope :sorted, lambda { order("#{table_name}.position") }
  scope :page_tabs, lambda { |page, user_id, entity_id|
    where(page_id: page, user: user_id, entity_id: entity_id).sorted
  }

  def self.add(page, user, entity_id, **attributes)
    user_id = user && user.id

    tab = EasyPageUserTab.new(page_id: page.id, user_id: user_id, entity_id: entity_id)
    tab.attributes = attributes

    if tab.name.blank?
      new_count = EasyPageUserTab.page_tabs(page.id, user_id, entity_id).size + 1
      tab.name = l(:label_easy_page_tab_default_name, count: new_count)
    end

    tab.save!

    if EasyPageUserTab.page_tabs(page.id, user_id, entity_id).where.not(id: tab.id).exists?
      # Not first tab on the page
    else
      # First tab on the page so all modules must be placed under it
      EasyPageZoneModule.where(easy_pages_id: page.id, user_id: user_id, entity_id: entity_id).update_all(tab_id: tab.id)
    end

    tab
  end

  def user_tab_modules(**options)
    page_definition.user_tab_modules(id, user_id, entity_id, **options)
  end

end
