#
# This helper is prepended into ApplicationHelper and
# should contains only things related to easy pages.
#
# It's done this way because of problem with including
# module to module which is already included.
#
module EasyConcerns
  module EasyPagesHelper
    extend ActiveSupport::Concern

    included do

      def render_easy_page_bottom_buttons(url=nil)
        url ||= { action: 'layout', t: params[:t] }

        template = easy_page_context[:page_params][:page_template]
        current_tab = easy_page_context[:page_params][:current_tab]

        content_for(:easy_page_layout_service_box_bottom) do
          content_tag(:div, class: 'customize-button-container') do

            if template
              tab_settings_path = load_settings_easy_page_template_tabs_path(
                id: current_tab,
                template_id: template)
            else
              tab_settings_path = load_settings_easy_page_tabs_path(
                id: current_tab,
                page_id: easy_page_context[:page_params][:page],
                entity_id: easy_page_context[:page_params][:entity_id],
                user_id: easy_page_context[:page_params][:user_id])
            end

            link_to(l(:label_personalize_page), url, class: 'customize-button button') +
            link_to('', tab_settings_path, remote: true, class: 'button-icon-only icon icon-settings tab-controls__edit', title: l(:title_easy_page_tab_settings))
          end
        end
      end

    end

  end
end
