class EasyXmlEasyPageTemplatesController < EasyXmlDataController

  def import_settings
    render template: 'easy_xml_data/easy_pages_import_settings'
  end

  private

  def entity_mapping
    'easy_page_mapping'
  end

  def create_exporter
    @exporter = EasyXmlData::EasyPageTemplateExporter.new(params['id'])
  end

  def get_filename
    if params[:id]
      template_name = EasyPageTemplate.where(id: params[:id]).pluck(:template_name).first
      filename = "#{template_name}_#{Time.now}.zip" if template_name
    end
    filename
  end

  def elements_to_validate
    { required_one: ['easy-pages', 'easy-page-templates'] }
  end

end
