class EasyResourceAvailabilitiesController < ApplicationController

  before_action :require_login
  before_action :authorize_global, :only => [:layout]

  def update
    uuid = params[:uuid]
    date = params[:date].to_date
    hour = params[:hour].blank? ? nil : params[:hour].to_i
    available = !params[:available].blank?
    day_start_time = params[:day_start_time].to_i
    day_end_time = params[:day_end_time].to_i
    description = params[:description]

    available = EasyResourceAvailability.set_availability(uuid, date, hour, available, description, day_start_time, day_end_time)

    if available
      render :nothing => true
    end
  end

  def index
    render_action_as_easy_page(EasyPage.find_by(page_name: 'easy-resource-booking-module'), nil, nil, easy_resource_availabilities_path(t: params[:t]), false)
  end

  def layout
    render_action_as_easy_page(EasyPage.find_by(page_name: 'easy-resource-booking-module'), nil, nil, easy_resource_availabilities_path(t: params[:t]), true)
  end

end
