class EasyQuerySettingsController < ApplicationController
  layout 'admin'
  menu_item :easy_query_settings

  before_action { |c| c.require_admin_or_lesser_admin(:easy_query_settings) }
  before_action :prepare_query, :only => [:setting, :save]

  helper :easy_query_settings
  include EasyQuerySettingsHelper
  helper :custom_fields
  include CustomFieldsHelper
  helper :easy_query
  include EasyQueryHelper
  helper :sort
  include SortHelper
  helper :attachments
  include AttachmentsHelper

  def index
    @easy_query = EasyQuery.registered_subclasses.keys.first.new
    default_settings
  end

  def setting
    default_settings
    render :action => 'index'
  end

  def save
    settings = (params[:easy_query] || {}).dup.symbolize_keys

    update_default_filters(params[:tab], params)
    update_default_custom_formatting(params[:tab], params)
    update_default_list_columns(params[:tab], settings[:column_names])
    update_default_grouped_by(params[:tab], settings[:group_by])
    update_default_sort(params[:tab], settings[:sort_criteria]) if settings[:sort_criteria]
    update_default_settings_criteria(params[:tab], settings)

    default_settings
    flash[:notice] = l(:notice_successful_update)
    render :action => 'index'
  end

  private

  def default_settings
    class_name = @easy_query.class.name.underscore
    settings = ['show_sum_row', 'load_groups_opened', 'show_avatars',
      'period_start_date', 'period_end_date', 'period_date_period',
      'period_date_period_type', 'period_zoom']
    settings.each { |s| @easy_query.send("#{s}=", EasySetting.value("#{class_name}_#{s}")) }
    @easy_query.group_by = EasySetting.value("#{class_name}_grouped_by")
    @easy_query.filters = EasySetting.value("#{class_name}_default_filters") || {}
    @easy_query.settings = EasySetting.value("#{class_name}_default_settings") || {}
  end

  def update_default_filters(easy_query, params)
    name = "#{easy_query}_default_filters"
    @easy_query.filters = {}
    @easy_query.add_filters(params[:fields], params[:operators], params[:values])
    update_easy_settings(name, @easy_query.filters)
  end

  def update_default_custom_formatting(easy_query, params)
    name = "#{easy_query}_default_custom_formatting"
    @easy_query.custom_formatting = {}
    @easy_query.add_custom_formatting_from_params(params)
    update_easy_settings(name, @easy_query.custom_formatting)
  end

  def update_default_list_columns(easy_query, values)
    name = "#{easy_query}_list_default_columns"
    update_easy_settings(name, values)
  end

  def update_default_grouped_by(easy_query, values)
    name = "#{easy_query}_grouped_by"
    update_easy_settings(name, values)
  end

  def update_default_settings_criteria(easy_query, values)
    settings = [
      {:name => "#{easy_query}_show_sum_row", :value => values[:show_sum_row].try(:to_boolean)},
      {:name => "#{easy_query}_load_groups_opened", :value => values[:load_groups_opened].try(:to_boolean)},
      {:name => "#{easy_query}_show_avatars", :value => values[:show_avatars].try(:to_boolean)},
      {:name => "#{easy_query}_period_start_date", :value => values[:period_start_date]},
      {:name => "#{easy_query}_period_end_date", :value => values[:period_end_date]},
      {:name => "#{easy_query}_period_zoom", :value => values[:period_zoom]},
      {:name => "#{easy_query}_period_date_period_type", :value => values[:period_date_period_type]},
      {:name => "#{easy_query}_period_date_period", :value => values[:period_date_period]}
    ]

    settings << {:name => "#{easy_query}_default_settings", :value => values[:settings]} if values[:settings].present?

    settings.each {|s| update_easy_settings(s[:name], s[:value])}
  end

  def update_default_sort(easy_query, values)
    sort_array, sort_string_s = Array.new, Array.new
    values.each do |_, sort|
      if sort[0].present? && sort[1].present?
        sort_array << [sort[0], sort[1]]
        sort_string_s << "#{sort[0]}:#{sort[1]}"
      elsif sort[0].present?
        sort_array << [sort[0], 'asc']
        sort_string_s << "#{sort[0]}:asc"
      end
    end

    update_easy_settings("#{easy_query}_default_sorting_array", sort_array)
    update_easy_settings("#{easy_query}_default_sorting_string_short", sort_string_s.join(','))
    update_easy_settings("#{easy_query}_default_sorting_string_long", sort_string_s.join(','))
  end

  def update_easy_settings(name, values)
    easy_setting = EasySetting.where(:name => name).first
    easy_setting ||= EasySetting.new(:name => name, :value => Array.new)
    easy_setting.value = values

    if !easy_setting.new_record? && values.blank? && values != false
      easy_setting.destroy
    else
      easy_setting.save
    end
  end

  def prepare_query
    begin
      @easy_query = params[:tab].classify.constantize.new if params[:tab]
    rescue
    end
    @easy_query = EasyQuery.registered_subclasses.keys.first.new if @easy_query.nil? || !@easy_query.is_a?(EasyQuery)
  end

end
