class EasyMeetingCalendarEvent < EasyCalendarEvent

  def uid
    object.uid
  end

  def etag
    object.etag
  end

  def title
    object.name
  end

  def starts_at
    object.start_time
  end

  def ends_at
    object.end_time
  end

  def all_day?
    object.all_day
  end

  def location
    object.try(:easy_room).try(:name).presence || object.place_name
  end

  def url
    Rails.application.routes.url_helpers.url_for(
      controller: 'easy_meetings',
      action:     'show',
      id:         object.id,
      only_path:  false,
      host: self.class.default_url_options[:host]
    )
  end

  def organizer
    if (a = object.author)
      return "MAILTO:#{a.mail}"
    end
  end

  def attendees
    object.external_mails.map{|u| "MAILTO:#{u}"}
  end

  def to_ical
    event = super
    event.description = object.description.to_s

    if (my_invitation = object.invitation_for(User.current)).is_a?(Array)
      Icalendar::Alarm.parse(my_invitation.alarms.join) do |alarm|
        event.add_alarm alarm
      end
    else
      event.alarm do |a|
        a.summary =  '5 minutes before'
        a.trigger = '-PT05M'
      end
      event.alarm do |a|
        a.summary = '30 minutes before'
        a.trigger = '-PT30M'
      end
    end

    object.easy_invitations.each do |inv|
      stat = inv.accepted? ? 'ACCEPTED' : 'DECLINED' unless inv.accepted.nil?
      prop = {'PARTSTAT' => stat, 'CN' => inv.user.name}

      if inv.user_id == object.author_id
        # prop['ROLE'] = 'CHAIR'
        next
      end
      attendee = Icalendar::Values::CalAddress.new("MAILTO:#{inv.user.mail}", prop)
      event.append_attendee(attendee)
    end

    event
  end

end
