class EasyRoomsDhtmlxSchedulerController < ApplicationController

  before_action :find_easy_room, :only => [:show, :events]

  def show
    respond_to do |format|
      format.html
      format.json {
        @easy_meetings = @easy_room.easy_meetings.where(['start_time >= ?', (Date.today - 1.year).beginning_of_day])
      }
    end
  end

  def update
  end

  private

  def find_easy_room
    @easy_room = EasyRoom.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

end
