module EasyAgileBoard
  module ApplicationHelperPatch

    def self.included(base)
      base.extend(ClassMethods)
      base.send(:include, InstanceMethods)

      base.class_eval do

        def link_to_project_with_easy_scrum_board(project, options = {})
          {:controller => 'easy_agile_board', :action => 'show', :id => project}
        end

        def link_to_project_with_easy_kanban_board(project, options = {})
          {:controller => 'easy_kanban', :action => 'show', :id => project}
        end

        def url_to_easy_sprint(easy_sprint, options={})
          project_easy_sprint_url(options[:project], easy_sprint, url_standard_options(options))
        end

        def include_easy_agile_board_headers_tags(project, easy_sprint)
          unless @easy_agile_board_headers_tags_included
            @easy_agile_board_headers_tags_included = true
            content_for :header_tags do
              render :partial => 'easy_agile_board/common_header', :locals => {:project => project, :easy_sprint => easy_sprint}
            end
          end

        end
      end
    end

    module InstanceMethods

    end

    module ClassMethods

    end

  end

end
EasyExtensions::PatchManager.register_helper_patch 'ApplicationHelper', 'EasyAgileBoard::ApplicationHelperPatch'
