class EpmPersonalEasyAgileBoard < EasyPageModule

  def category_name
    @category_name ||= 'easy_agile_board'
  end

  def permissions
    @permissions ||= [:view_easy_scrum_board]
  end

  def get_edit_data(settings, user, page_context = {})
    projects = page_context[:project] ? nil : Project.where("EXISTS (SELECT 1 AS one FROM #{EnabledModule.table_name} em WHERE em.project_id = #{Project.table_name}.id AND em.name='easy_scrum_board')")

    {project: page_context[:project], projects: projects }
  end

  def get_show_data(settings, user, page_context = {})
    if page_context[:project]
      project = page_context[:project]
    elsif settings['project_id'].present?
      project = Project.find_by(id: settings['project_id'])
    end

    if project
      easy_sprint = project.current_easy_sprint
      dont_use_project = easy_sprint.try(:cross_project?)
      query = EasyAgileBoardQuery.new(name: settings['heading'] || 'Scrum', dont_use_project: dont_use_project)
      query.project = project unless dont_use_project
      query.easy_sprint = easy_sprint

      if settings['only_me'] == '1'
        user_id = (user || User.current).id
        query.add_filter('assigned_to_id', '=', user_id) if user_id
      end
    end

    {query: query, project: project, easy_sprint: easy_sprint, settings: settings}
  end

end
