#*******************************************************************************
# clipboard_image_paste Redmine plugin.
#
# Hooks.
#
# Authors:
# - Richard Pecl
#
# Terms of use:
# - GNU GENERAL PUBLIC LICENSE Version 2
#*******************************************************************************

module ClipboardImagePaste
  class Hooks  < Redmine::Hook::ViewListener
    # Render image paste form on every page,
    # javascript allows the form to show on issues, news, files, documents, wiki
    render_on :view_layouts_base_body_bottom,
      :partial => "clipboard_image_paste/add_form"

    def easy_extensions_javascripts_hook(context={})
      context[:template].require_asset('clipboard_image_paste.js')
    end

    def easy_extensions_stylesheets_hook(context={})
      context[:template].require_asset('clipboard_image_paste.css')
    end

  end # class
end # module
