# DEV Guide - Code style

1. [Development types](./README.md#code-checking-&-requirements)
   1. [Client modifications](./1_CLIENT_MODIFICATIONS.md)
   2. [Separate existing plugin](./2_SEPARATE_EXISTING_PLUGIN.md)
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. [Core implementations](./4_CORE_IMPLEMENTATIONS.md)
2. [Development](#development)
3. **Code style**
4. [Common errors](./COMMON_ERRORS.md)
5. [Repositories](./REPOSITORIES.md)
6. [Testing](./TESTS.md)

Tato sekce je určena především pro [interní vývoj jádra](./4_CORE_IMPLEMENTATIONS.md). Pro klientské modifikace nebo samostatný plugin je toto pouze doporučení.

## Editor setup

**2 spaces for indention**

Use 2 spaces for indenting your code and swear an oath to never mix tabs and spaces - a special kind of hell is awaiting you otherwise.

**Unix line-endings**

Use UNIX-style newlines (\n), and a newline character as the last character of a file. Windows-style newlines (\r\n) are forbidden inside any repository.

**UTF-8 source coding only**

**No whitespace**

Just like you brush your teeth after every meal, you clean up any trailing whitespace in your JS files before committing. Otherwise the rotten smell of careless neglect will eventually drive away contributors and/or co-workers.


## Generals

**Do not change Redmine**

Do not change any Redmine files directly. We are plugin for Redmine not a fork.

**Try to use existing code**

Before adding something, inspire yourself with existing codebase. Try to find applicable existing solution, copy and modify it, but of course, remember to use your brain when pasting.

**Do not afraid to explore source code**

Whet you do something, look around for inspiration. Explore models, controllers or views and do it similarly - syntax, code style. If you using any method, you must know what exactly this method do - it mean that you will see whats this method contains.

**Comments**

Comments are required on complex code. Otherwise you should write _self-labeling_ code. It mean that methods name represent what exactly do.

```ruby
# BAD
def convert_date(project, issue, user, date, **options)
  ...
end

# GOOD
def render_user_name(user)
  user.name
end
```

**Quotes**

On Ruby single quotes preffered.

## Desing

##### Klíče překladu

Wording by měl odpovídat překladu a záreň by měl být co nejsrozumitelnější pro prográmátory. Pro klíče se používají prefixy:

- `button_`
- `error_`
- `field_`
- `label_`
- `text_`
- `title_`

##### Inline podmínky

```ruby
# Špatně
check_box_tag :is_default, @model && @model.is_defaut == 'yes' ? '1' : '0', id: 'is_default'

# Dobře
check_box_tag :is_default, (@model && @model.is_defaut == 'yes' ? '1' : '0'), id: 'is_default'
```

##### Odpovídající argumenty

```ruby
# Špatně
def my_method(data, key, value, date, type, other, options={})

# Dobře
def my_method(user, issue, **options)
def my_method(user, issue, html_options: '', html_id: '', date: nil)

```

##### Iterace a pojmenování

```ruby
# Špatně
issues.map{|x| x.project.versions.map{|y| y.css_classes}}.flatten

# Dobře
issues.flat_map { |issue| 
  issue.project.versions.map { |version| 
    version.css_classes 
  }
}
```

##### Case není odsazen

```ruby
# Špatně
case type
  when 'issue'
  when 'project'
  else
end

# Dobře
case type
when 'issue'
when 'project'
else
end

```

##### In HTML

  * for `class` attribute use use BEM convention - Block__Element_Modifier / multi-word-block-name__multi-word-element-name_modifier-name_modifier-value for complete reference go to https://en.bem.info/methodology/quick-start/

```html
  <div class="easy-query__heading-title_state_selected">...
```

  * for `id` attribute use `_` as separator

```html
  <div id="easy_entity_import_dialog">...
```

  * respect HTML valid syntax
  * use our CSS guideline instead own styles

##### Name routing

Named routes are prefered instead hash

```ruby
# BAD
url_for({controller: 'users', action: 'index'})

# GOOD
users_path
```
