class EasyEarnedValuesUpdater < EasyRakeTask

  def category_caption_key
    :label_easy_earned_values
  end

  def registered_in_plugin
    :easy_earned_values
  end

  def execute
    now = Time.now

    if now.hour.in?(0..6)
      date = Date.yesterday
    else
      date = Date.today
    end

    earned_values = EasyEarnedValue.for_reloading
    earned_values.find_each(batch_size: 10).with_index do |earned_value, index|
      if !earned_value.planned_loaded
        earned_value.reload_planned
      end

      earned_value.reload_actual(date)
    end

    true
  end

end
