class EasyChecklistQuery < EasyQuery

  def available_filters
    return @available_filters unless @available_filters.blank?
    @available_filters = {
      'author_id' => {:type => :list, :order => 1, :values => Proc.new { all_users_values(:include_me => true) }, :name => l(:field_author), :group => default_group_label},
      'name' => {:type => :string, :order => 2, :name => l(:field_name), :group => default_group_label}
    }

    return @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      @available_columns = [
        EasyQueryColumn.new(:author, :sortable => lambda{User.fields_for_order_statement}, :caption => :field_author, :group => default_group_label),
        EasyQueryColumn.new(:name, :sortable => "#{EasyChecklist.table_name}.name", :caption => :field_name, :group => default_group_label)
      ]

      @available_columns_added = true
    end
    @available_columns
  end

  def default_group_label
    l("label_filter_group_#{self.class.name.underscore}")
  end

  def entity_scope
    EasyChecklistTemplate.visible
  end

  def entity
    EasyChecklist
  end

  def default_list_columns
    super.presence || ['name', 'author']
  end

  def default_find_include
    [:author]
  end

  def searchable_columns
    ["#{User.table_name}.firstname", "#{User.table_name}.lastname", "#{EasyChecklist.table_name}.name"]
  end

end if Redmine::Plugin.installed?(:easy_extensions)
